% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Aggregate data moments for estimation
datamoms        = cell(1,2);

%% Moments collected from Compustat
% Correlation between Atilde and total reallocation
datamoms{1,1}  = 0.5393;
datamoms{1,2}  = 'C(Atilde,Reallocation)           ';

% Amount of capital reallocation, standard deviation over time
datamoms{2,1}   = .0190367;
datamoms{2,2}   = 'std(R/K)                         ';

% Fraction of adjusters, standard deviation over time
datamoms{3,1}   = .0272795;
datamoms{3,2}   = 'std(fraction R>0)                ';

% Correlation between GDP and the std in APK's
datamoms{4,1}  =  -0.6190;
datamoms{4,2}  = 'C(Atilde,sigma_APK)              ';

% Correlation between Atilde and the fraction of firms reallocating
datamoms{5,1}  = 0.3683;
datamoms{5,2}  = 'C(Atilde,pi)                     ';

% Autocorrelation of Atilde
datamoms{6,1}  =  .8527186 ;
datamoms{6,2}  = 'AR1(Atilde)                      ';

% Standard deviation of Atilde 
datamoms{7,1}  = .01614744;
datamoms{7,2}  = 'std(Atilde)                      ';




